<?php
// ++=========================================================================++
// || vBadvanced CMPS v2.0 RC2 (vB 3.5) - 6700
// ||  2003-2004 vBadvanced.com & PlurPlanet, LLC - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 20:07, Mon Jul 11th 2005
// || 
// ++ ========================================================================++

// ######################### Current Poll #########################
$query = array();

switch ($mod_options['portal_poll_orderby'])
{
	case 'rand':
		$query['orderby'] = 'RAND()';
		break;
	case 'dateline':
		$query['orderby'] = 'poll.dateline';
		break;
	default:
		$query['orderby'] = $mod_options['portal_poll_orderby'];
}

$mod_options['portal_threadids'] = unserialize($mod_options['portal_threadids']);

if (!empty($mod_options['portal_threadids']))
{
	$mods['threadids'] = 'AND thread.threadid IN(' . implode(',', array_keys($mod_options['portal_threadids'])) . ')';
}
else if ($mod_options['portal_poll_forumid'])
{
	$mods['inforums'] = explode(',', $mod_options['portal_poll_forumid']);

	if ($mod_options['portal_applypermissions'])
	{
		$mods['inforums'] = array_diff($mods['inforums'], $adv_forumperms);
	}
	if (empty($mods['inforums']))
	{
		$mods['inforums'] = '';
		$mods['nodisplay'] = true;
	}
	else
	{
		$mods['inforums'] = 'AND thread.forumid IN(' . implode(',', $mods['inforums']) . ')';
	}
}

if (!$mods['inforums'] AND !empty($adv_forumperms) AND $mod_options['portal_applypermissions'])
{
	$mods['exforums'] = 'AND thread.forumid NOT IN(' . implode(',', $adv_forumperms) . ')';
}

if ($vbulletin->userinfo['userid'] OR $mod_options['portal_poll_orderby'] == 'votedate')
{
	$query['pollfields'] = ', pollvoteid';
	$query['polljoin'] = 'LEFT JOIN ' . TABLE_PREFIX . 'pollvote AS pollvote ON (pollvote.pollid = poll.pollid AND pollvote.userid = ' . $vbulletin->userinfo['userid'] . ')';
}

if (!$mods['nodisplay'])
{
	$pollinfo = $db->query_first("
			SELECT thread.pollid, open, threadid, replycount, forumid, question, poll.dateline, options, votes, active, numberoptions, timeout, multiple, voters, public $query[pollfields]
			FROM " . TABLE_PREFIX . "poll AS poll
			INNER JOIN " . TABLE_PREFIX . "thread AS thread USING (pollid) 
			$query[polljoin]
			$deljoin
			WHERE open <> 10 AND thread.pollid != 0 AND visible = 1
			$mods[threadids]
			$mods[inforums]
			$mods[exforums]
			$notdeleted
			ORDER BY $query[orderby] $mod_options[portal_poll_direction]
	");
	
	if ($pollinfo['pollid'])
	{
		$pollinfo['question'] = $bbcode_parser->parse($pollinfo['question'], 'nonforum', $mod_options['portal_poll_allowsmilies']);
	
		$splitoptions = explode('|||', $pollinfo['options']);
		$splitvotes = explode('|||', $pollinfo['votes']);
	
		foreach ($splitvotes AS $key => $value)
		{
			$pollinfo['nvotes'] += $value;
		}

		$pollforumperms = fetch_permissions($pollinfo['forumid']);

		if (!$pollinfo['active'] OR !$pollinfo['open'] OR ($pollinfo['dateline'] + ($pollinfo['timeout'] * 86400) < TIMENOW AND $pollinfo['timeout']) OR !($pollforumperms & $vbulletin->bf_ugp_forumpermissions['canvote']))
		{
			$pollinfo['showresults'] = 1;
	
			$pollinfo['message'] = iif(($pollforumperms & $vbulletin->bf_ugp_forumpermissions['canvote']), $vbphrase['this_poll_is_closed'], $vbphrase['you_may_not_vote_on_this_poll']);
		}
	
		if (fetch_bbarray_cookie('poll_voted', $pollinfo['pollid']) OR $pollinfo['pollvoteid'])
		{
			$pollinfo['showresults'] = 1;
			$pollinfo['message'] = $vbphrase['you_have_already_voted_on_this_poll'];
		}
	
		if (can_moderate($pollinfo['forumid'], 'caneditpoll'))
		{
			$show['editpoll'] = true;
		}
	
		$pollbits = '';

		$option = '';
	
		foreach ($splitvotes AS $key => $value)
		{
			$option['question'] = $bbcode_parser->parse($splitoptions["$key"], '', $mod_options['portal_poll_allowsmilies']);
	
			$option['votes'] = $value;
			$option['number'] = $key + 1;
	
			if ($pollinfo['showresults'])
			{
				$option['percent'] = 0;
				if ($value)
				{
					$option['percent'] = vb_number_format($value / $pollinfo['nvotes'] * 100, 2);
				}
	
				$option['graphicnumber'] = $option['number'] % 6 + 1;
				$option['barnumber'] = intval($option['percent'] * 1.4);
	
				eval('$pollbits .= "' . fetch_template('adv_portal_pollresult') . '";');
			}
			elseif ($pollinfo['multiple'])
			{
				eval('$pollbits .= "' . fetch_template('adv_portal_polloption_multiple') . '";');
			}
			else
			{
				eval('$pollbits .= "' . fetch_template('adv_portal_polloption') . '";');
			}
		}
	
		eval('$home["$mods[modid]"][\'content\'] .= "' . fetch_template('adv_portal_poll') . '";');
	}
}

unset($pollbits, $pollinfo, $option, $pollbits, $query);
?>